/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.TankModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class BucketingModifier
extends TankModifier {
    public BucketingModifier() {
        super(1000);
    }

    @Override
    public int getPriority() {
        return 80;
    }

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (context.getChangedSlot() == EquipmentSlot.CHEST) {
            ModifierUtil.addTotalArmorModifierLevel(tool, context, TinkerDataKeys.SHOW_EMPTY_OFFHAND, 1, true);
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (context.getChangedSlot() == EquipmentSlot.CHEST) {
            ModifierUtil.addTotalArmorModifierLevel(tool, context, TinkerDataKeys.SHOW_EMPTY_OFFHAND, -1, true);
        }
    }

    private static boolean cannotContainFluid(Level world, BlockPos pos, BlockState state, Fluid fluid) {
        LiquidBlockContainer container;
        Block block = state.m_60734_();
        return !state.m_60722_(fluid) && (!(block instanceof LiquidBlockContainer) || !(container = (LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, state, fluid));
    }

    @Override
    public InteractionResult beforeBlockUse(IToolStackView tool, int level, UseOnContext context, EquipmentSlot slot) {
        BlockPos target;
        if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        BlockEntity te = world.m_7702_(target = context.m_8083_());
        if (te == null) {
            return InteractionResult.PASS;
        }
        Direction face = context.m_43719_();
        LazyOptional capability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face);
        if (!capability.isPresent()) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            Player player = context.m_43723_();
            boolean sneaking = player != null && player.m_6144_();
            capability.ifPresent(cap -> {
                FluidStack fluidStack = this.getFluid(tool);
                SoundEvent sound = null;
                if (sneaking) {
                    int added;
                    if (!fluidStack.isEmpty() && (added = cap.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                        sound = fluidStack.getFluid().getAttributes().getEmptySound(fluidStack);
                        fluidStack.shrink(added);
                        this.setFluid(tool, fluidStack);
                    }
                } else if (fluidStack.isEmpty()) {
                    FluidStack drained = cap.drain(this.getCapacity(tool), IFluidHandler.FluidAction.EXECUTE);
                    if (!drained.isEmpty()) {
                        this.setFluid(tool, drained);
                        sound = drained.getFluid().getAttributes().getFillSound(drained);
                    }
                } else {
                    FluidStack drained = cap.drain(new FluidStack(fluidStack, this.getCapacity(tool) - fluidStack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                    if (!drained.isEmpty() && drained.isFluidEqual(fluidStack)) {
                        fluidStack.grow(drained.getAmount());
                        this.setFluid(tool, fluidStack);
                        sound = drained.getFluid().getAttributes().getFillSound(drained);
                    }
                }
                if (sound != null) {
                    world.m_5594_(null, target, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            });
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @Override
    public InteractionResult afterBlockUse(IToolStackView tool, int level, UseOnContext context, EquipmentSlot slotType) {
        Player player = context.m_43723_();
        if (player == null || !player.m_6144_()) {
            return InteractionResult.PASS;
        }
        FluidStack fluidStack = this.getFluid(tool);
        if (fluidStack.getAmount() < 1000) {
            return InteractionResult.PASS;
        }
        Fluid fluid = fluidStack.getFluid();
        if (!(fluid instanceof FlowingFluid)) {
            return InteractionResult.PASS;
        }
        Direction face = context.m_43719_();
        Level world = context.m_43725_();
        BlockPos target = context.m_8083_();
        BlockPos offset = target.m_142300_(face);
        if (!world.m_7966_(player, target) || !player.m_36204_(offset, face, context.m_43722_())) {
            return InteractionResult.PASS;
        }
        BlockState existing = world.m_8055_(target);
        if (BucketingModifier.cannotContainFluid(world, target, existing, fluidStack.getFluid()) && BucketingModifier.cannotContainFluid(world, target = offset, existing = world.m_8055_(target), fluidStack.getFluid())) {
            return InteractionResult.PASS;
        }
        boolean placed = false;
        if (world.m_6042_().m_63951_() && fluid.m_205067_(FluidTags.f_13131_)) {
            world.m_5594_(player, target, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)target.m_123341_() + Math.random(), (double)target.m_123342_() + Math.random(), (double)target.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
            }
            placed = true;
        } else if (existing.m_60722_(fluid)) {
            if (!world.f_46443_ && !existing.m_60767_().m_76332_()) {
                world.m_46961_(target, true);
            }
            if (world.m_46597_(target, fluid.m_76145_().m_76188_()) || existing.m_60819_().m_76170_()) {
                world.m_5594_(null, target, fluid.getAttributes().getEmptySound(fluidStack), SoundSource.BLOCKS, 1.0f, 1.0f);
                placed = true;
            }
        } else {
            Block block = existing.m_60734_();
            if (block instanceof LiquidBlockContainer) {
                LiquidBlockContainer container = (LiquidBlockContainer)block;
                container.m_7361_((LevelAccessor)world, target, existing, ((FlowingFluid)fluid).m_76068_(false));
                world.m_5594_(null, target, fluid.getAttributes().getEmptySound(fluidStack), SoundSource.BLOCKS, 1.0f, 1.0f);
                placed = true;
            }
        }
        if (placed) {
            this.drain(tool, fluidStack, 1000);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, int level, Level world, Player player, InteractionHand hand, EquipmentSlot slotType) {
        BucketItem bucketItem;
        Fluid pickedUpFluid;
        Item item;
        BucketPickup bucketPickup;
        ItemStack bucket;
        if (player.m_6047_()) {
            return InteractionResult.PASS;
        }
        FluidStack fluidStack = this.getFluid(tool);
        if (this.getCapacity(tool) - fluidStack.getAmount() < 1000) {
            return InteractionResult.PASS;
        }
        BlockHitResult trace = ModifiableItem.blockRayTrace(world, player, ClipContext.Fluid.SOURCE_ONLY);
        if (trace.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        Direction face = trace.m_82434_();
        BlockPos target = trace.m_82425_();
        BlockPos offset = target.m_142300_(face);
        if (!world.m_7966_(player, target) || !player.m_36204_(offset, face, player.m_6844_(slotType))) {
            return InteractionResult.PASS;
        }
        FluidState fluidState = world.m_6425_(target);
        Fluid currentFluid = fluidStack.getFluid();
        if (fluidState.m_76178_() || !fluidStack.isEmpty() && !currentFluid.m_6212_(fluidState.m_76152_())) {
            return InteractionResult.PASS;
        }
        BlockState state = world.m_8055_(target);
        Block block = state.m_60734_();
        if (block instanceof BucketPickup && !(bucket = (bucketPickup = (BucketPickup)block).m_142598_((LevelAccessor)world, target, state)).m_41619_() && (item = bucket.m_41720_()) instanceof BucketItem && (pickedUpFluid = (bucketItem = (BucketItem)item).getFluid()) != Fluids.f_76191_) {
            player.m_5496_(pickedUpFluid.getAttributes().getFillSound(fluidStack), 1.0f, 1.0f);
            if (!world.f_46443_) {
                if (fluidStack.isEmpty()) {
                    this.setFluid(tool, new FluidStack(pickedUpFluid, 1000));
                } else if (pickedUpFluid == currentFluid) {
                    fluidStack.grow(1000);
                    this.setFluid(tool, fluidStack);
                } else {
                    TConstruct.LOG.error("Picked up a fluid {} that does not match the current fluid state {}, this should not happen", (Object)pickedUpFluid, (Object)fluidState.m_76152_());
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

